# Instruções de Instalação - Plugin PIX Gateway

## Problema Identificado
O erro crítico que você está enfrentando pode ser causado por:

1. **Plugin não ativado corretamente**
2. **Estrutura de diretórios incorreta**
3. **Conflito com outros plugins**
4. **Versão do WordPress/PHP incompatível**

## Passos para Resolver

### 1. Verificar Estrutura de Diretórios
Certifique-se de que a estrutura está assim:
```
wp-content/plugins/woocommerce-pix-gateway/
├── woocommerce-pix-gateway.php
├── includes/
│   └── class-wc-pix-gateway.php
├── admin/
│   └── admin-page.php
├── assets/
│   ├── css/
│   └── js/
└── templates/
```

### 2. Reativar o Plugin
1. Vá para **Plugins > Plugins Instalados**
2. **Desative** o plugin "WooCommerce - Berapay"
3. **Ative** novamente o plugin
4. Verifique se não há mensagens de erro

### 3. Verificar Logs de Erro
1. Vá para **WooCommerce > Status > Logs**
2. Procure por logs com "pix" ou "gateway"
3. Verifique se há erros específicos

### 4. Testar Conexão Básica
1. Acesse: `seu-site.com/wp-admin/admin.php?page=wc-pix-gateway-settings`
2. Se der erro, verifique se o plugin está ativo

### 5. Verificar Requisitos
- **WordPress**: 5.0 ou superior
- **WooCommerce**: 5.0 ou superior
- **PHP**: 7.4 ou superior

### 6. Teste Alternativo
Se ainda der erro, teste este arquivo simples:
1. Acesse: `seu-site.com/wp-content/plugins/woocommerce-pix-gateway/test-debug.php`
2. Deve mostrar informações sobre o ambiente

## Solução de Problemas Comuns

### Erro: "Página não encontrada"
- Verifique se o plugin está ativo
- Limpe o cache do site
- Verifique se o WooCommerce está ativo

### Erro: "Permissão negada"
- Verifique se você está logado como administrador
- Verifique se tem permissão para gerenciar WooCommerce

### Erro: "Função não definida"
- O plugin não está sendo carregado corretamente
- Verifique se há conflitos com outros plugins

## Configuração Após Instalação

1. **Configurar API**:
   - API Key: Sua chave fornecida pelo gateway
   - API URL: URL base da API
   - Tempo de expiração: 30 minutos (padrão)

2. **Configurar WooCommerce**:
   - WooCommerce > Configurações > Pagamentos
   - Ativar "Berapay"
   - Configurar título e descrição

3. **Testar Pagamento**:
   - Criar pedido de teste
   - Escolher PIX como método de pagamento
   - Verificar se QR Code aparece

## Suporte

Se o problema persistir:
1. Verifique os logs de erro
2. Teste em modo de debug
3. Desative outros plugins temporariamente
4. Entre em contato com o suporte

## Arquivos Importantes

- **Principal**: `woocommerce-pix-gateway.php`
- **Gateway**: `includes/class-wc-pix-gateway.php`
- **Admin**: `admin/admin-page.php`
- **Config**: `config.php`

## Última Verificação

Antes de usar em produção:
1. Teste em ambiente de desenvolvimento
2. Verifique todos os métodos de pagamento
3. Teste webhooks se disponível
4. Verifique logs de transações
